﻿//////////////////////////////////////////////
// JpgQuantizationTable.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>
#include <NilkinsMemory/Containers/BufferView.h>

// Standards
#include <vector>

/// Class ------------------------------------

namespace nkImages::jpg
{
	enum class JPG_QUANTIZATION_TYPE
	{
		LUMINANCE = 0,
		CHROMINANCE
	} ;

	class JpgQuantizationTable final
	{
		public :

			// Constructors
			JpgQuantizationTable () noexcept ;
			JpgQuantizationTable (float qualityFactor, unsigned int tableIndex, JPG_QUANTIZATION_TYPE type) noexcept ;
			JpgQuantizationTable (nkMemory::Buffer&& compressionMemory, unsigned int tableIndex) noexcept ;

			// Functions
			// Writing
			unsigned int getMarkerSpotByteSize (bool writeMarker) const ;
			void writeMarkerSpot (unsigned char* out, bool writeMarker = false, unsigned short sectionSize = 0u) ;

			// Parsing
			static void parseFromMarker (const unsigned char* data, std::vector<JpgQuantizationTable>& output) ;

		public :

			// Attributes
			nkMemory::Buffer _compressionMemory ;
			nkMemory::BufferView<const unsigned char> _table ;

			unsigned int _tableIndex ;
	} ;
}